<?php
header('Content-Type: application/json');

$file_path = 'reports.json';

// Verifica se o arquivo existe
if (!file_exists($file_path)) {
    echo json_encode(['success' => false, 'message' => 'Arquivo não encontrado']);
    exit;
}

// Tenta limpar o arquivo
try {
    // Verifica permissões de escrita
    if (!is_writable($file_path)) {
        echo json_encode(['success' => false, 'message' => 'Permissão negada para escrever no arquivo']);
        exit;
    }
    
    // Salva um array vazio no arquivo
    file_put_contents($file_path, json_encode([]));
    
    echo json_encode(['success' => true, 'message' => 'Mensagens limpas com sucesso']);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erro ao limpar mensagens: ' . $e->getMessage()]);
}
?>